<?php
/*
	Stempora web framework
	copyright (c) 2002-2016 Stempora
		web:  www.stempora.com
		mail: support@stempora.com

*/



/**
* description
*
* @library	
* @author	
* @since	
*/
class CTemplateDynamic{
	
	function __construct($source , $source_type = "file") {
		$this->source = array(
				"file" => $source , 
				"type" => $source_type
			);		

		$this->dynamic = true;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Replace($vars , $clear) {
		$this->__checkObject();

		return $this->template->Replace($vars , $clear);
		
	}

	function EmptyVars($vars = array()) {
		$this->__checkObject();

		//if i have variables then dinamicaly replace them
		if (count($vars)) 
			$this->template->Replace($vars , false);			
		
		return $this->template->EmptyVars();
	}

	function SwapIO() {
		$this->__checkObject();

		$this->template->input = $this->template->output;
	}



	function Block($block) {
		$this->__checkObject();

		if (!is_object($this->template->blocks[$block])) {
			$this->error($block);
			return NULL;
		} else {
			return $this->template->blocks[$block]->output;
		}
	}

	function BlockSetInput($block , $data) {
		$this->__checkObject();

		if (!is_object($this->template->blocks[$block])) {
			$this->error($block);
			return NULL;
		} else {
			return $this->template->blocks[$block]->input = $data;
		}
	}

	function BlockReplaceSingle($block , $var, $value) {
		return $this->template->BlockReplace(
			$block , 
			array(
				$var => $value
			)
		);
	}

	
	function BlockReplace() {
		$this->__checkObject();


		$args = func_get_args();

		if (!is_object($this->template->blocks[$args[0]])) {
			$this->error($args[0]);
			return NULL;
		} else {

			$params = $args;

			unset($params[0]);

			if (is_array($params[1])) {
				$tmp = $this->template->blocks[$args[0]]->Replace($params[1]);

				if (count($params) > 1) {
					unset($params[1]);

					foreach ($params as $key => $val) {
						$tmp = CTemplateStatic::Replace(
							$tmp , 
							$val
						);
					}
					
				}
				
				return $tmp;
			} else {
				return $this->template->blocks[$args[0]]->Replace(array());
			}
			
		}
	}

	function BlockEmptyVars($block , $vars , $clear = true) {
		$this->__checkObject();

		if (!is_object($this->template->blocks[$block])) {
			$this->error($block);
			return NULL;
		} else {
			$this->template->blocks[$block]->Replace($vars , false);
			return $this->template->blocks[$block]->EmptyVars();
		}
	}


	function BlockSwapIO($block) {
		$this->__checkObject();

		if (!is_object($this->template->blocks[$block])) {
			$this->error($block);
			return NULL;
		} else {
			$this->template->blocks[$block]->input = $this->template->blocks[$block]->output;
		}
	}
		
	function __checkObject() {
		if (!is_object($this->template)) {
			$this->template = new CTemplate(
						$this->source["file"],
						$this->source["type"]
				);
		}
	}

	function BlockExists() {
		$this->__checkObject();

		if (func_num_args() > 0) {
			$blocks = func_get_args();

			$error = true;
			for ($i = 0; $i < count($blocks); $i++) {
				if (!is_object($this->template->blocks[$blocks[$i]])) {
					return false;
				}				
			}				
		}		

		return $error;
	}

	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Error($block) {
		trigger_error(
			"CTemplateDynamic::BlockSwapIO::_invalid object: 
				<ul>
					<li> - block: {$block} doesnt exist </li>
					<li> - template: {$this->source[file]}</li>
				</ul>
			",
			E_USER_ERROR
		);
	}
	

}

?>